/*!
\file CDGL_IDirect3DDevice9.h
//! This file contains the declaration of the class CDGL_IDirect3DDevice9. 
	This class is the concrete implementation of IDirect3DDevice9 interface in Direct3D9. The class IDirect3DDevice9 is made as an abstract class in d3d9.h (DXInclude)file.
\author Shilpa Prabhu
\version v1.0
\date 26Oct04
\copyright © 1994-2004 by Robosoft Technologies, all rights reserved.
\change history (most recent first)
\ <1>   26Oct04 Shilpa Prabhu Created file
*/

#ifndef __CDGL_IDIRECT3DDEVICE9_H__
#define __CDGL_IDIRECT3DDEVICE9_H__

#include <Carbon/Carbon.h>
#include "d3d9.h"
#include "DXGraphicsInit.h"

#ifndef LIB_CHANGES
#include "OZone/IRenderer.h"
#include "OZone/Defines.h"
#include "OZone/GraphicsInit.h"
#include "OZone/IVertexBuffer.h"
#else
#include "IRenderer.h"
#include "Defines.h"
#include "GraphicsInit.h"
#include "IVertexBuffer.h"
#endif	// LIB_CHANGES


#include "DXGraphics.h"
#include "DXGraphicsUtils.h"
#include "OpenGL/glext.h"
#include "CDGL_IDirect3D9.h"
#include "CDGL_IDirect3DVertexBuffer9.h"
#include "CDGL_IDirect3DIndexBuffer9.h"
#include "CDGL_IDirect3DTexture9.h"
#include "CDGL_IDirect3DSurface9.h"
#include "CDGL_IDirect3DVertexShader9.h"
#include "CDGL_IDirect3DPixelShader9.h"
#include "CDGL_IDirect3DVolumeTexture9.h"

#include <iostream>
#include "CDGL_IDirect3DVertexDeclaration9.h"

/*!
\struct  SamplerState
\brief  This structure holds the Direct3D sampler state values.
\detail In Direct3D there can be upto 16 samplers(check SetSamplerState function). This structure is
		used to hold the state type and value for these 16 possible sampler states.
*/
typedef struct SamplerState
{
	//D3DSAMPLERSTATETYPE f_Type;
	bool  isModified;
	DWORD f_dwValue;
	
	SamplerState()
	{
		isModified = false;
	}
}SamplerState;



/*!
\class  CDGL_IDirect3DDevice9
\brief  This class is the concrete implementation  of IDirect3DDevice9 abstract class.
\detail Applications use the methods of the IDirect3DDevice9 interface to perform DrawPrimitive-based rendering, create resources, 
		work with system-level variables, adjust gamma ramp levels, work with palettes, and create shaders.
*/
class CDGL_IDirect3DDevice9 : public IDirect3DDevice9
{
	public:
		//! Constructor
		CDGL_IDirect3DDevice9(IDirect3D9 *p, D3DPRESENT_PARAMETERS *pPresentationParameters, GL_PresentParams in_GLPresentParams);
		CDGL_IDirect3DDevice9(IDirect3D9 *p, D3DPRESENT_PARAMETERS *pPresentationParameters, GL_PresentParams in_GLPresentParams, HWND&);
		//! Desturctor
		~CDGL_IDirect3DDevice9();
		
		//! IUnknown methods 
		
		//! Increments the reference count by 1.
		ULONG AddRef();
		//! Determines whether the object supports a particular interface. If it does, the system increases the object's reference count, and the application can use that interface immediately.
		HRESULT QueryInterface(REFIID riid, void **ppvObj);
		//! Decrements the reference count of this class. If reference count becomes 0, releases all the allocated memory and deletes this class.
		ULONG Release();
		
		//! IDirect3DDevice9 methods
		
		//! Begins a scene
		HRESULT BeginScene();
		//! Signals Microsoft® Direct3D® to begin recording a device-state block.
		HRESULT BeginStateBlock();
		//! Clears the viewport, or a set of rectangles in the viewport, to a specified RGBA color, clears the depth buffer, and erases the stencil buffer. 
		HRESULT Clear(DWORD Count, CONST D3DRECT *pRects, DWORD Flags, D3DCOLOR Color, float Z, DWORD Stencil);
		//! Allows an application to fill a rectangular area of a D3DPOOL_DEFAULT surface with a specified color.
		HRESULT ColorFill(IDirect3DSurface9* pSurface,CONST RECT* pRect,D3DCOLOR color);
		//! Creates an additional swap chain for rendering multiple views.
		HRESULT CreateAdditionalSwapChain(D3DPRESENT_PARAMETERS *pPresentationParameters, IDirect3DSwapChain9 **pSwapChain);
		//! Creates a cube texture resource.
		HRESULT CreateCubeTexture(UINT EdgeLength, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DCubeTexture9 **ppCubeTexture,HANDLE* pSharedHandle);
		//! Creates a depth-stencil resource.
		HRESULT CreateDepthStencilSurface(UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample,DWORD MultisampleQuality,BOOL Discard, IDirect3DSurface9 **ppSurface,HANDLE* pSharedHandle);
		//! Creates an index buffer.
		HRESULT CreateIndexBuffer(UINT Length, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DIndexBuffer9 **ppIndexBuffer,HANDLE* pSharedHandle);
		//! Create an off-screen surface.
		HRESULT CreateOffscreenPlainSurface(UINT Width,UINT Height,D3DFORMAT Format,D3DPOOL Pool,IDirect3DSurface9** ppSurface,HANDLE* pSharedHandle);
		//! Creates a pixel shader.
		HRESULT CreatePixelShader(CONST DWORD *pFunction, IDirect3DPixelShader9** ppShader);
		//! Creates a status query.
		HRESULT CreateQuery( D3DQUERYTYPE Type,IDirect3DQuery9** ppQuery);
		//! Creates a render target surface.
		HRESULT CreateRenderTarget(UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality,BOOL Lockable, IDirect3DSurface9 **ppSurface,HANDLE* pSharedHandle);
		//! Creates a new state block that contains the values for all device states, vertex-related states, or pixel-related states.
		HRESULT CreateStateBlock(D3DSTATEBLOCKTYPE Type, IDirect3DStateBlock9** ppSB);
		//! Creates a texture resource.
		HRESULT CreateTexture(UINT Width, UINT Height, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DTexture9 **ppTexture,HANDLE* pSharedHandle);
		//! Creates a vertex buffer.
		HRESULT CreateVertexBuffer(UINT Length, DWORD Usage, DWORD FVF, D3DPOOL pool, IDirect3DVertexBuffer9 **ppVertexBuffer,HANDLE* pSharedHandle);
		//! Create a vertex shader declaration from the device and the vertex elements.
		HRESULT CreateVertexDeclaration( CONST D3DVERTEXELEMENT9* pVertexElements,IDirect3DVertexDeclaration9** ppDecl);
		//! Creates a vertex shader.
		HRESULT CreateVertexShader( CONST DWORD* pFunction,IDirect3DVertexShader9** ppShader);
		//! Creates a volume texture resource.
		HRESULT CreateVolumeTexture(UINT Width, UINT Height, UINT Depth, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DVolumeTexture9 **ppVolumeTexture,HANDLE* pSharedHandle);
		//! Frees a cached high-order patch.
		HRESULT DeletePatch(UINT Handle);
		//! Renders the specified geometric primitive, based on indexing into an array of vertices.
		//shilpa - here BaseVertexIndex is new in DX9
		HRESULT DrawIndexedPrimitive(D3DPRIMITIVETYPE type,INT BaseVertexIndex, UINT minIndex, UINT NumVertices, UINT startIndex, UINT primCount);
		//! Renders the specified geometric primitive with data specified by a user memory pointer.
		HRESULT DrawIndexedPrimitiveUP(D3DPRIMITIVETYPE type, UINT MinVertexIndex, UINT NumVertexIndices, UINT PrimitiveCount, CONST void *pIndexData, D3DFORMAT IndexDataFormat, CONST void *pVertexStreamZeroData, UINT VertexStreamZeroStride);
		//! Renders a sequence of nonindexed, geometric primitives of the specified type from the current set of data input streams.
		HRESULT DrawPrimitive(D3DPRIMITIVETYPE PrimitiveTYpe, UINT StartVertex, UINT PrimiveCount);
		//! Renders data specified by a user memory pointer as a sequence of geometric primitives of the specified type.
		HRESULT DrawPrimitiveUP(D3DPRIMITIVETYPE PrimitiveType, UINT PrimitiveCount, CONST void *pVertexStreamZeroData, UINT VertexStreamZeroStride);
		//! Draws a rectangular patch using the currently set streams.
		HRESULT DrawRectPatch(UINT Handle, CONST float *pNumSegs, CONST D3DRECTPATCH_INFO *pRectPatchInfo);
		//! Draws a triangular patch using the currently set streams.
		HRESULT DrawTriPatch(UINT Handle, CONST float *pNumSegs, CONST D3DTRIPATCH_INFO *pTriPatchInfo);
		//! Ends a scene that was begun by calling the IDirect3DDevice9::BeginScene method
		HRESULT EndScene();
		//! Signals Direct3D to stop recording a device-state block and retrieve a handle to the state block.
		HRESULT EndStateBlock( IDirect3DStateBlock9** ppSB);
		//! Evicts all managed resources, including both Direct3D and driver-managed resources.
		HRESULT EvictManagedResources();
		//! Returns an estimate of the amount of available texture memory.
		UINT	GetAvailableTextureMem();
		//! Retrieves a back buffer from the device's swap chain
		HRESULT GetBackBuffer(UINT iSwapChain,UINT BackBuffer, D3DBACKBUFFER_TYPE Type, IDirect3DSurface9 **ppBackBuffer);
		//! Retrieves the coefficients of a user-defined clipping plane for the device.
		HRESULT GetClipPlane(DWORD Index, float *pPlane);
		//! Retrieves the clip status.
		HRESULT GetClipStatus(D3DCLIPSTATUS9 *pClipStatus);
		//! Retrieves the creation parameters of the device.
		HRESULT GetCreationParameters(D3DDEVICE_CREATION_PARAMETERS *pParameters);
		//! Retrieves the current texture palette.
		HRESULT GetCurrentTexturePalette(UINT *PaletteNumber);
		//! Gets the depth-stencil surface owned by the Direct3DDevice object.
		HRESULT GetDepthStencilSurface(IDirect3DSurface9 **ppZStencilSurface);
		//! Retrieves the capabilities of the rendering device.
		HRESULT GetDeviceCaps(D3DCAPS9 *pCaps);
		//! Returns an interface to the instance of the Direct3D object that created the device.
		HRESULT GetDirect3D(IDirect3D9 **ppD3D);
		//! Retrieves the display mode's spatial resolution, color resolution, and refresh frequency.
		HRESULT GetDisplayMode(UINT iSwapChain,D3DDISPLAYMODE* pMode);
		//! Generates a copy of the device's front buffer and places that copy in a system memory buffer provided by the application. 
		HRESULT GetFrontBufferData(UINT iSwapChain,IDirect3DSurface9* pDestSurface);
		//! Gets the fixed vertex function declaration.
		HRESULT GetFVF( DWORD* pFVF); //Shilpa on 30 Oct 04
		//! Retrieves the gamma correction ramp for the swap chain.
		void	GetGammaRamp(UINT iSwapChain,D3DGAMMARAMP *pRamp);
		//! Retrieves index data.
		HRESULT GetIndices(IDirect3DIndexBuffer9 **ppIndexData);
		//! Retrieves a set of lighting properties that this device uses.
		HRESULT GetLight(DWORD Index, D3DLIGHT9 *p);
		//! Retrieves the activity status
		HRESULT GetLightEnable(DWORD Index , BOOL *pEnable);
		//! Retrieves the current material properties for the device.
		HRESULT GetMaterial(D3DMATERIAL9 *pMaterial);
		//! Gets the N-patch mode segments.
		float   GetNPatchMode();
		//! Gets the number of implicit swap chains.
		UINT	GetNumberOfSwapChains();
		//! Retrieves palette entries.
		HRESULT GetPaletteEntries(UINT PaletteNumber, PALETTEENTRY *pEntries);
		//! Retrieves the currently set pixel shader.
		HRESULT GetPixelShader( IDirect3DPixelShader9** ppShader);
		//! Gets a Boolean shader constant.
		HRESULT GetPixelShaderConstantB( UINT StartRegister,BOOL* pConstantData,UINT BoolCount);
		//! Gets a floating-point shader constant.
		HRESULT GetPixelShaderConstantF( UINT StartRegister,float* pConstantData,UINT Vector4fCount);
		//! Gets an integer shader constant.
		HRESULT GetPixelShaderConstantI( UINT StartRegister,int* pConstantData,UINT Vector4iCount);
		//! Returns information describing the raster of the monitor on which the swap chain is presented.
		HRESULT GetRasterStatus(UINT iSwapChain,D3DRASTER_STATUS *pRasterStatus);
		//! Retrieves a render-state value for a device.
		HRESULT GetRenderState(D3DRENDERSTATETYPE State, DWORD *pValue);
		//! Retrieves a render target surface.
		HRESULT GetRenderTarget(DWORD RenderTargetIndex,IDirect3DSurface9** ppRenderTarget);
		//! Copies the render target data from device memory to system memory.
		HRESULT GetRenderTargetData(IDirect3DSurface9* pRenderTarget,IDirect3DSurface9* pDestSurface);
		//! Gets the sampler state value.
		HRESULT GetSamplerState( DWORD Sampler,D3DSAMPLERSTATETYPE Type,DWORD* pValue);
		//! Gets the scissor rectangle.
		HRESULT GetScissorRect( RECT* pRect);
		//! Gets the vertex processing (hardware or software) mode.
		BOOL	GetSoftwareVertexProcessing();
		//! Retrieves a vertex buffer bound to the specified data stream.
		HRESULT GetStreamSource(UINT StreamNumber, IDirect3DVertexBuffer9 **ppStreamData,UINT* OffsetInBytes, UINT *pStride);
		//! Gets the stream source frequency divider value.
		HRESULT GetStreamSourceFreq( UINT StreamNumber,UINT* Divider);
		//! Gets a pointer to a swap chain.
		HRESULT GetSwapChain(UINT iSwapChain,IDirect3DSwapChain9** pSwapChain);
		//! Retrieves a texture assigned to a stage for a device.
		HRESULT GetTexture(DWORD Stage, IDirect3DBaseTexture9 **ppTexture);
		//! Retrieves a state value for an assigned texture
		HRESULT GetTextureStageState(DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD *pValue);
		//! Retrieves a matrix describing a transformation state.
		HRESULT GetTransform(D3DTRANSFORMSTATETYPE State, D3DMATRIX *pMatrix);
		//! Gets a vertex shader declaration.
		HRESULT GetVertexDeclaration(IDirect3DVertexDeclaration9** ppDecl);
		//! Retrieves the currently set vertex shader.
		HRESULT GetVertexShader(  IDirect3DVertexShader9** ppShader);
		//! Gets a Boolean vertex shader constant.
		HRESULT GetVertexShaderConstantB( UINT StartRegister,BOOL* pConstantData,UINT BoolCount);
		//! Gets a floating-point vertex shader constant.
		HRESULT GetVertexShaderConstantF( UINT StartRegister,float* pConstantData,UINT Vector4fCount);
		//! Gets an integer vertex shader constant.
		HRESULT GetVertexShaderConstantI( UINT StartRegister,int* pConstantData,UINT Vector4iCount);
		//! Retrieves the viewport parameters currently set for the device.
		HRESULT GetViewport(D3DVIEWPORT9 *pViewport);		
		//! Enables or disables a set of lighting parameters within a device.
		HRESULT LightEnable(DWORD Index, BOOL Enable);
		//! Multiplies a device's world, view, or projection matrices by a specified matrix. 
		HRESULT MultiplyTransform(D3DTRANSFORMSTATETYPE state, CONST D3DMATRIX *pMatrix);
		//! Presents the contents of the next buffer in the sequence of back buffers owned by the device.
		HRESULT Present(CONST RECT *pSourceRect, CONST RECT *pDestRect, HWND hDestWindowOverride, CONST RGNDATA *pDirtyRegion);
		//! Applies the vertex processing defined by the vertex shader to the set of input data streams, generating a single stream of interleaved vertex data to the destination vertex buffer. 
		HRESULT ProcessVertices(UINT SrcStartIndex, UINT DestIndex, UINT VertexCount, IDirect3DVertexBuffer9 *pDestBuffer,IDirect3DVertexDeclaration9* pVertexDecl, DWORD Flags);
		//! Resets the type, size, and format of the swap chain.
		HRESULT Reset(D3DPRESENT_PARAMETERS *pPresentationParameters);
		//! Sets the coefficients of a user-defined clipping plane for the device.
		HRESULT SetClipPlane(DWORD Index, CONST float *pPlane);
		//! Sets the clip status.
		HRESULT SetClipStatus(CONST D3DCLIPSTATUS9 *pClipStatus);
		//! Sets the current texture palette.
		HRESULT SetCurrentTexturePalette(UINT PaletteNumber);
		//! Sets the cursor position and update options.
		void	SetCursorPosition(int XScreenSpace, int YScreenSpace, DWORD Flags);
		//! Sets properties for the cursor.
		HRESULT SetCursorProperties(UINT XHotSpot, UINT YHotSport, IDirect3DSurface9 *pCursorBitmap);
		//! Sets the depth stencil surface.
		HRESULT SetDepthStencilSurface(IDirect3DSurface9* pNewZStencil);
		//! This method allows the use of Microsoft Windows® Graphics Device Interface (GDI) dialog boxes in full-screen mode applications.
		HRESULT SetDialogBoxMode(BOOL bEnableDialogs);
		//! Sets the current vertex stream declaration.
		HRESULT SetFVF( DWORD FVF);//Shilpa on 30 Oct 04
		//! Sets the gamma correction ramp for the implicit swap chain.
		void	SetGammaRamp(UINT iSwapChain, DWORD Flags, CONST D3DGAMMARAMP *pRamp);
		//! Sets index data.
		HRESULT SetIndices(IDirect3DIndexBuffer9* pIndexData); 
		//! Assigns a set of lighting properties for this device.	Yes
		HRESULT SetLight(DWORD Index, CONST D3DLIGHT9 *p);
		//! Sets the material properties for the device.
		HRESULT SetMaterial(CONST D3DMATERIAL9 *pMaterial);
		//! Enable or disable N-patches.
		HRESULT SetNPatchMode( float nSegments);
		//! Sets palette entries
		HRESULT SetPaletteEntries(UINT PaletteNumber, CONST PALETTEENTRY *pEntries);
		//! Sets the current pixel shader to a previously created pixel shader.
		HRESULT SetPixelShader(IDirect3DPixelShader9* pShader);
		//! Sets a Boolean shader constant.
		HRESULT SetPixelShaderConstantB( UINT StartRegister,const BOOL* pConstantData,UINT  BoolCount);
		//! Sets a floating-point shader constant.
		HRESULT SetPixelShaderConstantF( UINT StartRegister,const float* pConstantData,UINT Vector4fCount);
		//! Sets an integer shader constant.
		HRESULT SetPixelShaderConstantI( UINT StartRegister,const int* pConstantData,UINT Vector4iCount);
		//! Sets a single device render-state parameter
		HRESULT SetRenderState(D3DRENDERSTATETYPE State, DWORD pValue);
		//! Sets a new color buffer for the device.
		HRESULT SetRenderTarget(DWORD RenderTargetIndex,IDirect3DSurface9* pRenderTarget);
		//! Sets the sampler state value.
		HRESULT SetSamplerState( DWORD Sampler,D3DSAMPLERSTATETYPE Type,DWORD Value);
		//! Sets the scissor rectangle.
		HRESULT SetScissorRect( const RECT* pRect);
		//! Use this method to switch between software and hardware vertex processing.
		HRESULT SetSoftwareVertexProcessing( BOOL bSoftware);
		//! Binds a vertex buffer to a device data stream. For more information, see Setting the Stream Source.
		HRESULT SetStreamSource(UINT StreamNumber, IDirect3DVertexBuffer9 *ppStreamData,UINT OffsetInBytes, UINT pStride);
		//! Sets the stream source frequency divider value.
		HRESULT SetStreamSourceFreq( UINT StreamNumber,UINT Divider);
		//! Assigns a texture to a stage for a device.
		HRESULT SetTexture(DWORD Stage, IDirect3DBaseTexture9 *ppTexture);
		//! Sets the state value for the currently assigned texture.
		HRESULT SetTextureStageState(DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD pValue);
		//! Sets a single device transformation-related state.
		HRESULT SetTransform(D3DTRANSFORMSTATETYPE State, CONST D3DMATRIX *pMatrix);
		//! Sets a vertex shader declaration.
		HRESULT SetVertexDeclaration(IDirect3DVertexDeclaration9* pDecl);
		//! Sets the vertex shader.
		HRESULT SetVertexShader(IDirect3DVertexShader9* pShader);
		//! Sets a Boolean vertex shader constant
		HRESULT SetVertexShaderConstantB( UINT StartRegister,const BOOL* pConstantData,UINT  BoolCount);
		//! Sets a floating-point vertex shader constant.
		HRESULT SetVertexShaderConstantF( UINT StartRegister,const float* pConstantData,UINT Vector4fCount);
		//! Sets an integer vertex shader constant.
		HRESULT SetVertexShaderConstantI( UINT StartRegister,const int* pConstantData,UINT Vector4iCount);
		//! Sets the viewport parameters for the device.
		HRESULT SetViewport(CONST D3DVIEWPORT9 *pViewport);
		//! Displays or hides the cursor.
		BOOL	ShowCursor(BOOL bShow);
		//! Copy the contents of the source rectangle to the destination rectangle. The source rectangle can be stretched and filtered by the copy. This function is often used to change the aspect ratio of a video stream.
		HRESULT StretchRect(IDirect3DSurface9* pSourceSurface,CONST RECT* pSourceRect,IDirect3DSurface9* pDestSurface,CONST RECT* pDestRect,D3DTEXTUREFILTERTYPE Filter);
		//! Reports the current cooperative-level status of the Direct3D device for a windowed or full-screen application.
		HRESULT TestCooperativeLevel();
		//! Copies rectangular subsets of pixels from one surface to another. 
		HRESULT UpdateSurface(IDirect3DSurface9* pSourceSurface,CONST RECT* pSourceRect,IDirect3DSurface9* pDestinationSurface,CONST POINT* pDestPoint);
		//! Updates the dirty portions of a texture.
		HRESULT UpdateTexture(IDirect3DBaseTexture9 *pSourceTexture, IDirect3DBaseTexture9 *pDestinationTexture);
		//! Reports the device's ability to render the current texture-blending operations and arguments in a single pass.
		HRESULT ValidateDevice(DWORD *pNumPasses);
		
		
		void CDGL_IDirect3DDevice9::InitializeDeviceVariables(IDirect3D9 *p, D3DPRESENT_PARAMETERS *pPresentationParameters, GL_PresentParams in_GLPresentParams) ; //sharathchandra

		//! Additional Methods
		
		//! Checks if a particular OpenGL extension is supported 
		bool IsExtSupported(eOGL_EXTS in_Ext) { return m_abExtensions[in_Ext]; }  
		void ResetSettings(GL_PresentParams in_GLPresentParams);
	
		//! Returen the device cpas if anybody else from outside would require ... 
		D3DCAPS9*	GetTheDeviceCaps(); // sharathchandra 
	
		// return the window reference
		HWND		GetWindowHandle();
	
		private:

		//! Private methods
		
		//! Returns the current FVF
		DWORD GetCurrentFVF() const;
		//! Returns the current stream FVF size
		DWORD GetCurrentFVFSize() const;
		//! Gives the pointer to current vertex buffer's vertex data.
		CONST VOID *GetCurrentVertexData() const;
		//! Gives the pointer to current index buffer's index data.
		CONST VOID *GetCurrentIndexData() const;
		//! Activates a texture unit.
		void ActivateTextureUnit(DWORD in_dwSampler); //Shilpa on 25 Nov 04
		//! Sets the texture matrix of a particular texture stage(unit) to invert the y coordinate
//		void SetTexYCoordInvMatrixForStage(int in_lStage); //Shilpa on 4 Feb 05

		//! Member Variables
		
		//! Array having an entry for each of the possible state of type D3DRENDERSTATETYPE.
		DWORD						m_dwRenderState[256];		
		//! Pointer to IDirect3D9 interface from which this interface was created
		IDirect3D9				*	m_pIDirect3D9;
		//! Currently set material
		D3DMATERIAL9				m_D3DMaterial;
		//! Current viewport
		D3DVIEWPORT9				m_D3DViewport;
		//! The current Gamma Ramp
		D3DGAMMARAMP				m_D3DRamp;
		//! Current display mode
		D3DDISPLAYMODE				m_D3DDisplayMode;
		//! The creation parameters for this device object
		D3DDEVICE_CREATION_PARAMETERS m_D3DCreationParameters;
		//! The 16 possible light settings
		D3DLIGHT9					m_aD3DLight[16];
		//! The state (On/Off) of 16 possible lights
		BOOL						m_abLight[16];
		//! The currently set palette number
		UINT						m_lPaletteNumber;
		//! The clip planes
		float						m_afPlane[32];
		//! The current clip status
		D3DCLIPSTATUS9				m_D3DClipStatus;
		//! The current vertex shader handle
		IDirect3DVertexShader9 *	m_pVertexShaderHandle; //Shilpa - In DX9
	
		//! The current pixel shader handle : Bala Adding
		IDirect3DPixelShader9 *		m_pPixelShaderHandle;
	
		//! the current view, projection and world matrix
		D3DMATRIX					m_ViewMatrix, m_ProjectionMatrix, m_WorldMatrix;
		//! The texture matrices set currently for each of the 8 texture stages
		D3DMATRIX					m_TexMat[8]; //Shilpa on 3 Feb 05
		//! The currently set texture objects for each of the 8 texture stages
		IDirect3DBaseTexture9 *		m_apTexture[8];
		//! The current stencil surface
		IDirect3DSurface9 *			m_apZStencilSurface;
		//! The back buffer
		IDirect3DSurface9 *			m_apBackBuffer;
		//! The base vertex index of the currently set vertex stream
		UINT						m_lBaseVertexIndex;
		//! The vertex buffer set currently
		IDirect3DVertexBuffer9	*	m_pCurrentVertexBuffer;
		//! The vertex stride of the currently set vertex stream
		UINT						m_lCurrentVertexStride;
		//! The index buffer set currently
		IDirect3DIndexBuffer9	*	m_pCurrentIndexBuffer;
		//!  The FVF of the currently set vertex stream
		DWORD						m_dwCurrentStreamFVF;
		//! The FVF size of the currently set vertex stream
		DWORD						m_dwCurrentStreamFVFSize;
		//! The reference count of this object
		int							m_lrefCount;
		//! This member variable contains the FVF (Flexible Vertex Format) of vertex buffer.
		DWORD						m_dwFVF;
		DWORD						mPrevFVF;
	
		//! The current values of the sampler states (there can be upto 16 samplers)
		SamplerState				m_aSampler[16][D3DSAMP_DMAPOFFSET]; // Bala : making it 2D : to hold each sampler state value
		//! To store point scales A, B, C - required for distance based size attenuation of point sprites.
		float						m_afPointScale[3]; 
		//! To store the texture stage states for each of the 8 texture stages
		DWORD						m_dwTextureStageState[8][40]; //shilpa on 20 Dec 04 - to store the texture stage states.
		//! The present parameters for this device
		GL_PresentParams			m_GLPresentParams;
		//! Booleans to indicate if any OpenGL extension is supported in the system or not.
		bool						m_abExtensions[ke_OGLEXTCount]; //Shilpa on 9 Feb 05
		
		/*for VAR in DrawPrimitiveUP
		char*						m_pVertexArrayMemPointer[10000]; //Shilpa 11 Apr 05
		UInt32						m_lVertexArrayMemCount;//Shilpa 11 Apr 05
		GLint						m_alVARIDs[10000];//Shilpa 11 Apr 05*/
	
	//====================================================================================
	
	// Private methods
	eVBPrimitiveType				_getGLPrimitiveType(D3DPRIMITIVETYPE );
	UInt32							_calculatePrimitiveIndexCount(D3DPRIMITIVETYPE, UInt32 );
	void							_initDeviceCaps();
	void							_initContextCaps();
	void							_setVBSpecifiers();
	void							_prepareToRender();
	OZoneDataType					_mapDXTypeToOZoneType(BYTE dxType, int &numOfComponents);
	void							_initRenderStateMappingArray();
	int								_mapDXWrapModetoOZWrapMode(DWORD);
	int								_mapDXFilterModetoOZFilterMode(DWORD);
	int								_combineMinAndMipFilters(DWORD, DWORD);
	void							_setTextureParametersOnRenderer();
	void							_setShaderConstantsOnRenderer();
	void							_setUpMatrices();
	void							_convertD3DMatrixToGL(float *, float *);
	void							_convertD3DColorToGL(D3DCOLORVALUE, float *);
	float							_mapSpecularPowerToGL(float);
	void							_convertColor(UInt32, float *);
	int								_fillInPixelFormatAttribs(D3DPRESENT_PARAMETERS*, GL_PresentParams, int*);
	int								_getRedBitsFromD3DFormat(D3DFORMAT);
	int								_getGreenBitsFromD3DFormat(D3DFORMAT);
	int								_getBlueBitsFromD3DFormat(D3DFORMAT);
	int								_getAlphaBitsFromD3DFormat(D3DFORMAT);
	
	// we need a renderer
	IRenderer					mRenderer;
	D3DCAPS9					mD3DDeviceCaps;
	IDirect3DVertexDeclaration9 *mCurrentVertexDeclaration;
	UInt32						mRenderStateMap[256];
	int							mSamplerStateValues[16][2];
	int							mMaxVSConstants;
	int							mMaxPSConstants;
	bool						mUseVertexDeclaration;
	bool						mWorldViewMatrixModified;
	bool						mProjectionMatrixModified;
	bool						mViewMatrixMultiplied;
	float						mTextureFactor[4];
	
	HWND						mWindow;
	
	// shader constants
	void *						mVertexShaderConstants;
	void *						mPixelShaderConstants;
	
	IDirect3DSurface9 *			mRenderTarget; 
	
	int mDeviceWidth, mDeviceHeight, mBytesperPixel; 
	
	
	
	//====================================================================================
	
};

#endif //__CDGL_IDIRECT3DDEVICE9_H__
